unit Question2_u;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtraItem_u;

type
  TfrmQuestion2 = class(TForm)
    Label1: TLabel;
    edtGuestNumber: TEdit;
    btnListItems: TButton;
    redDisplay: TRichEdit;
    procedure FormActivate(Sender: TObject);
    procedure btnListItemsClick(Sender: TObject);
  private
    { Private declarations }
    arrItems: array [1 .. 20] of String;
    iCounter: Integer;
    item: TExtraItems;
  public
    { Public declarations }
  end;

var
  frmQuestion2: TfrmQuestion2;

implementation

{$R *.dfm}

procedure TfrmQuestion2.btnListItemsClick(Sender: TObject);
  var
    i, iGuestNum, iPos, iSearch: Integer;
    sItem, sName, sLine: String;
    rCost, rProfit, rFinalCost: Real;
    bFound: Boolean;
  begin
    rFinalCost := 0;
    bFound := False;
    iSearch := StrToInt(edtGuestNumber.Text);

    redDisplay.Lines.Add('Information on extra items for guest number ' +
        IntToStr(iSearch));
    redDisplay.Lines.Add('');
    redDisplay.Lines.Add('Item' + #9 + 'Cost' + #9 + 'Profit' + #9 + 'Price');
    for i := 1 to iCounter do
      begin
        sLine := arrItems[i];

        iPos := Pos('#', sLine);
        iGuestNum := StrToInt(Copy(sLine, 1, iPos - 1));
        if iGuestNum = iSearch then
          begin
            bFound := True;
            delete(sLine, 1, iPos);

            iPos := Pos('#', sLine);
            sName := Copy(sLine, 1, iPos - 1);
            delete(sLine, 1, iPos);

            iPos := Pos('#', sLine);
            sItem := Copy(sLine, 1, iPos - 1);
            delete(sLine, 1, iPos);

            rCost := StrToFloat(sLine);

            item := TExtraItems.Create(iGuestNum, sItem, rCost);
            rProfit := item.calculateProfit;
            rFinalCost := rFinalCost + item.calculatePrice;
            redDisplay.Lines.Add(item.toString);
          end;

      end;

    redDisplay.Lines.Add('');
    redDisplay.Lines.Add('The total amount due is ' + FloatToStrF(rFinalCost, ffCurrency, 8, 2));

    if NOT bFound then
      begin
        redDisplay.Lines.Clear;
        redDisplay.Lines.Add
          ('There are no extra charges for guest number ' + IntToStr(iSearch));
      end;
  end;

procedure TfrmQuestion2.FormActivate(Sender: TObject);
  var
    tItems: TextFile;
  begin
    redDisplay.Paragraph.TabCount := 3;
    redDisplay.Paragraph.Tab[0] := 80;
    redDisplay.Paragraph.Tab[1] := 140;
    redDisplay.Paragraph.Tab[2] := 200;
    // Read text file
    iCounter := 0;

    if FileExists('Extras.txt') then
      begin
        AssignFile(tItems, 'Extras.txt');
        Reset(tItems);

        while NOT EOF(tItems) do
          begin
            Inc(iCounter);
            Readln(tItems, arrItems[iCounter]);
          end;
      end
    else
      begin
        ShowMessage('The required file cannot be located.');
        Close;
      end;

  end;

end.
